/** @file   smallwormai.h
 * @brief   Declaration of SmallWormAI class
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SMALLWORMAI_H
#define H_WWW_SMALLWORMAI_H

#include "aicontroller.h"

namespace WeWantWar {


/** @class  SmallWormAI
 * @brief   Contains the logic that controls the SmallWormAlien
 * @author  Tomi Lamminsaari
 *
 * Small Worm Aliens moves randomly around the game level. Only way they react
 * to the player is that they shoot several bullets around themselves as player
 * gets close enough.
 * @par
 * When this alien dies, it shoots several bullet around himself.
 */
class SmallWormAI : public AIController
{
public:
  /** Constructor
   */
  SmallWormAI( GameObject* pAlien );
  
  /** Destructor.
   */
  virtual ~SmallWormAI();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Controls the small worm.
   */
  virtual void updateAI( bool seeTarget, float dist );
  
protected:

  ///
  /// Members
  /// =======
  
  
private:
  SmallWormAI( const SmallWormAI& rO );
  SmallWormAI& operator = ( const SmallWormAI& rO );
};

};  // end of namespace

#endif // SMALLWORMAI_H

/**
 * Version history
 * ===============
 * $Log: smallwormai.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:16+02  lamminsa
 * Initial revision
 *
 */
 
